/* $Id: i2c.c,v 1.4 1998/10/28 18:55:07 ericb Exp $ */
/* Copyright (C) 1996 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Eric Backus */

#include "sema.h"

SHORTSIZ16 EXPORT
e1432_read_i2c(E1432ID hw, SHORTSIZ16 ID,
	       SHORTSIZ16 addr, SHORTSIZ16 *value)
{
    E1432_GROUP_LIST_NODE *gn;
    E1432_CHAN_LIST_NODE *cn;
    SHORTSIZ16 error, error2, temp;
    LONGSIZ32 ltmp;
    int     first, cindex;

    TRACE_PRINTF(0, ("e1432_read_i2c(0x%p, %d, %d, 0x%p)\n",
		     hw, ID, addr, value));

    /* Check for valid id */
    error = i1432_checkID(hw, ID);
    if (error)
	return error;

    /* Check if channel or group */
    if (ID < 0)
    {
	/* Iterate thru group making sure that all parameters match */
	gn = i1432_get_group_node(hw, ID);
	cn = gn->chanlist;

	/* Check each channel */
	first = 1;
	while (cn)
	{
	    error = e1432_read_i2c(hw, cn->chanID, addr, &temp);
	    if (error)
		return error;
	    if (first)
	    {
		*value = temp;
		first = 0;
	    }
	    if (temp != *value)
		return i1432_print_error(ERR1432_PARAMETER_UNEQUAL);
	    cn = cn->next;
	}
    }
    else
    {
	/* get lone channel */
	cindex = i1432_get_chan_index(hw, ID);

	error = i1432_introff();
	if (error)
	    return error;

	error = i1432_write_cmd2(hw, ID, E1432_CCMD_READ_I2C_BYTE,
				 cindex, addr);
	if (error)
	    goto cleanup;
	error = i1432_read_resp(hw, ID, &ltmp);

    cleanup:
	error2 = i1432_intron();
	if (error2)
	    return error2;

	if (error)
	    return error;

	*value = (SHORTSIZ16) ltmp;
    }

    return 0;
}

SHORTSIZ16 EXPORT
e1432_write_i2c(E1432ID hw, SHORTSIZ16 ID,
		SHORTSIZ16 addr, SHORTSIZ16 value)
{
    E1432_GROUP_LIST_NODE *gn;
    E1432_CHAN_LIST_NODE *cn;
    SHORTSIZ16 error;
    int     cindex;

    TRACE_PRINTF(0, ("e1432_write_i2c(0x%p, %d, %d, %d)\n",
		     hw, ID, addr, value));

    /* Check for valid id */
    error = i1432_checkID(hw, ID);
    if (error)
	return error;

    /* check if channel or group */
    if (ID < 0)
    {
	/* iterate thru group */
	gn = i1432_get_group_node(hw, ID);
	cn = gn->chanlist;
	while (cn)
	{
	    error = e1432_write_i2c(hw, cn->chanID, addr, value);
	    if (error)
		return error;
	    cn = cn->next;
	}
	return 0;
    }
    else
    {
	/* set lone channel */
	cindex = i1432_get_chan_index(hw, ID);
	error = i1432_write_cmd3(hw, ID, E1432_CCMD_WRITE_I2C_BYTE,
				 cindex, addr, value);
	if (error)
	    return error;
	return 0;
    }
}
